/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.IModelConfiguration;

@OnlyIn(value=Dist.CLIENT)
public class SimpleBakedModel
implements IBakedModel {
    protected final List<BakedQuad> field_177563_a;
    protected final Map<Direction, List<BakedQuad>> field_177561_b;
    protected final boolean field_177562_c;
    protected final boolean field_177559_d;
    protected final boolean field_230186_e_;
    protected final TextureAtlasSprite field_177560_e;
    protected final ItemCameraTransforms field_177558_f;
    protected final ItemOverrideList field_188620_g;

    public SimpleBakedModel(List<BakedQuad> p_i230059_1_, Map<Direction, List<BakedQuad>> p_i230059_2_, boolean p_i230059_3_, boolean p_i230059_4_, boolean p_i230059_5_, TextureAtlasSprite p_i230059_6_, ItemCameraTransforms p_i230059_7_, ItemOverrideList p_i230059_8_) {
        this.field_177563_a = p_i230059_1_;
        this.field_177561_b = p_i230059_2_;
        this.field_177562_c = p_i230059_3_;
        this.field_177559_d = p_i230059_5_;
        this.field_230186_e_ = p_i230059_4_;
        this.field_177560_e = p_i230059_6_;
        this.field_177558_f = p_i230059_7_;
        this.field_188620_g = p_i230059_8_;
    }

    @Override
    public List<BakedQuad> func_200117_a(@Nullable BlockState p_200117_1_, @Nullable Direction p_200117_2_, Random p_200117_3_) {
        return p_200117_2_ == null ? this.field_177563_a : this.field_177561_b.get((Object)p_200117_2_);
    }

    @Override
    public boolean func_177555_b() {
        return this.field_177562_c;
    }

    @Override
    public boolean func_177556_c() {
        return this.field_177559_d;
    }

    @Override
    public boolean func_230044_c_() {
        return this.field_230186_e_;
    }

    @Override
    public boolean func_188618_c() {
        return false;
    }

    @Override
    public TextureAtlasSprite func_177554_e() {
        return this.field_177560_e;
    }

    @Override
    public ItemCameraTransforms func_177552_f() {
        return this.field_177558_f;
    }

    @Override
    public ItemOverrideList func_188617_f() {
        return this.field_188620_g;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Builder {
        private final List<BakedQuad> field_177656_a = Lists.newArrayList();
        private final Map<Direction, List<BakedQuad>> field_177654_b = Maps.newEnumMap(Direction.class);
        private final ItemOverrideList field_188646_c;
        private final boolean field_177655_c;
        private TextureAtlasSprite field_177652_d;
        private final boolean field_230187_f_;
        private final boolean field_177653_e;
        private final ItemCameraTransforms field_177651_f;

        public Builder(IModelConfiguration model, ItemOverrideList overrides) {
            this(model.useSmoothLighting(), model.isSideLit(), model.isShadedInGui(), model.getCameraTransforms(), overrides);
        }

        public Builder(BlockModel p_i230060_1_, ItemOverrideList p_i230060_2_, boolean p_i230060_3_) {
            this(p_i230060_1_.func_178309_b(), p_i230060_1_.func_230176_c_().func_230178_a_(), p_i230060_3_, p_i230060_1_.func_181682_g(), p_i230060_2_);
        }

        private Builder(boolean p_i230061_1_, boolean p_i230061_2_, boolean p_i230061_3_, ItemCameraTransforms p_i230061_4_, ItemOverrideList p_i230061_5_) {
            for (Direction direction : Direction.values()) {
                this.field_177654_b.put(direction, Lists.newArrayList());
            }
            this.field_188646_c = p_i230061_5_;
            this.field_177655_c = p_i230061_1_;
            this.field_230187_f_ = p_i230061_2_;
            this.field_177653_e = p_i230061_3_;
            this.field_177651_f = p_i230061_4_;
        }

        public Builder func_177650_a(Direction p_177650_1_, BakedQuad p_177650_2_) {
            this.field_177654_b.get((Object)p_177650_1_).add(p_177650_2_);
            return this;
        }

        public Builder func_177648_a(BakedQuad p_177648_1_) {
            this.field_177656_a.add(p_177648_1_);
            return this;
        }

        public Builder func_177646_a(TextureAtlasSprite p_177646_1_) {
            this.field_177652_d = p_177646_1_;
            return this;
        }

        public IBakedModel func_177645_b() {
            if (this.field_177652_d == null) {
                throw new RuntimeException("Missing particle!");
            }
            return new SimpleBakedModel(this.field_177656_a, this.field_177654_b, this.field_177655_c, this.field_230187_f_, this.field_177653_e, this.field_177652_d, this.field_177651_f, this.field_188646_c);
        }
    }
}

